/* http://keith-wood.name/gChart.html
   Google Chart interface for jQuery v1.3.1.
   See API details at http://code.google.com/apis/chart/.
   Written by Keith Wood (kbwood{at}iinet.com.au) September 2008.
   Dual licensed under the GPL (http://dev.jquery.com/browser/trunk/jquery/GPL-LICENSE.txt) and 
   MIT (http://dev.jquery.com/browser/trunk/jquery/MIT-LICENSE.txt) licenses. 
   Please attribute the author if you use it. */
(function($){function GChart(){this._defaults={width:0,height:0,format:'png',usePost:false,margins:null,title:'',titleColor:'',titleSize:0,opacity:0,backgroundColor:null,chartColor:null,legend:'',legendOrder:'normal',legendSize:null,type:'pie3D',encoding:'',series:[this.series('Hello World',[60,40])],visibleSeries:0,dataLabels:[],axes:[],ranges:[],markers:[],icons:[],minValue:0,maxValue:100,gridSize:[],gridLine:[],gridOffsets:[],extension:{},barWidth:null,barSpacing:null,barGroupSpacing:null,barZeroPoint:null,pieOrientation:0,mapArea:'world',mapRegions:[],mapDefaultColor:'bebebe',mapColors:['blue','red'],qrECLevel:null,qrMargin:null,onLoad:null,provideJSON:false}};var G='gChart';var H={aqua:'008080',black:'000000',blue:'0000ff',fuchsia:'ff00ff',gray:'808080',green:'008000',grey:'808080',lime:'00ff00',maroon:'800000',navy:'000080',olive:'808000',orange:'ffa500',purple:'800080',red:'ff0000',silver:'c0c0c0',teal:'008080',transparent:'00000000',white:'ffffff',yellow:'ffff00'};var I={line:'lc',lineXY:'lxy',sparkline:'ls',barHoriz:'bhs',barVert:'bvs',barHorizGrouped:'bhg',barVertGrouped:'bvg',pie:'p',pie3D:'p3',pieConcentric:'pc',venn:'v',scatter:'s',radar:'r',radarCurved:'rs',map:'t',meter:'gom',qrCode:'qr',formula:'tx',lc:'lc',lxy:'lxy',ls:'ls',bhs:'bhs',bvs:'bvs',bhg:'bhg',bvg:'bvg',p:'p',p3:'p3',pc:'pc',v:'v',s:'s',r:'r',rs:'rs',t:'t',gom:'gom',qr:'qr',tx:'tx'};var J={annotation:'A',arrow:'a',candlestick:'F',circle:'o',cross:'x',diamond:'d',down:'v',errorbar:'E',flag:'f',financial:'F',horizbar:'H',horizontal:'h',number:'N',plus:'c',rectangle:'C',sparkfill:'B',sparkline:'D',sparkslice:'b',square:'s',text:'t',vertical:'V'};var K={behind:-1,below:-1,normal:0,above:+1,inFront:+1,'-':-1,'+':+1};var L={diagonalDown:-45,diagonalUp:45,horizontal:0,vertical:90,dd:-45,du:45,h:0,v:90};var M={left:-1,center:0,centre:0,right:+1,l:-1,c:0,r:+1};var N={line:'l',ticks:'t',both:'lt'};var O={normal:'l',reverse:'r',automatic:'a','':'',l:'l',r:'r',a:'a'};var P={barbase:'s',barcenter:'c',barcentre:'c',bartop:'e',bottom:'b',center:'h',centre:'h',left:'l',middle:'v',right:'r',top:'t',b:'b',c:'c',e:'e',h:'h',l:'l',r:'r',s:'s',t:'t',v:'v'};var Q='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';var R='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.';$.extend(GChart.prototype,{markerClassName:'hasGChart',calculate:-0.123,barWidthAuto:'a',barWidthRelative:'r',formatFloat:'f',formatPercent:'p',formatScientific:'e',formatCurrency:'c',setDefaults:function(a){extendRemove(this._defaults,a||{})},series:function(a,b,c,d,e,f,g,h){if($.isArray(a)){h=g;g=f;f=e;e=d;d=c;c=b;b=a;a=''}if(typeof c=='number'){h=f;g=e;f=d;e=c;d=null;c=null}if(typeof d=='number'){h=g;g=f;f=e;e=d;d=null}if($.isArray(f)){h=f;g=e;f=null;e=null}return{label:a,data:b||[],color:c||'',fillColor:d,minValue:e,maxValue:f,lineThickness:g,lineSegments:h}},seriesFromCsv:function(h){var j=[];if(!$.isArray(h)){h=h.split('\n')}if(!h.length){return j}var k=false;var l=[];var m=[];var n=['label','color','fillColor','minValue','maxValue','lineThickness','lineSegmentLine','lineSegmentGap'];$.each(h,function(i,c){var d=c.split(',');if(i==0&&isNaN(parseFloat(d[0]))){$.each(d,function(i,a){if($.inArray(a,n)>-1){l[i]=a}else if(a.match(/^x\d+$/)){m[i]=a}})}else{var e={};var f=[];var g=null;$.each(d,function(i,a){if(l[i]){var b=$.inArray(l[i],n);e[l[i]]=(b>2?$.gchart._numeric(a,0):a)}else if(m[i]){g=(a?$.gchart._numeric(a,-1):null);k=true}else{var y=$.gchart._numeric(a,-1);f.push(g!=null?[g,y]:y);g=null}});if(e.lineSegmentLine!=null&&e.lineSegmentGap!=null){e.lineSegments=[e.lineSegmentLine,e.lineSegmentGap];e.lineSegmentLine=e.lineSegmentGap=null}j.push($.extend(e,{data:f}))}});return(k?this.seriesForXYLines(j):j)},seriesFromXml:function(f){if($.browser.msie&&typeof f=='string'){var g=new ActiveXObject('Microsoft.XMLDOM');g.validateOnParse=false;g.resolveExternals=false;g.loadXML(f);f=g}f=$(f);var h=[];var j=false;try{f.find('series').each(function(){var b=$(this);var c=[];b.find('point').each(function(){var a=$(this);var x=a.attr('x');if(x!=null){j=true;x=$.gchart._numeric(x,-1)}y=$.gchart._numeric(a.attr('y'),-1);c.push(x?[x,y]:y)});var d=b.attr('lineSegments');if(d){d=d.split(',');for(var i=0;i<d.length;i++){d[i]=$.gchart._numeric(d[i],1)}}h.push({label:b.attr('label'),data:c,color:b.attr('color'),fillColor:b.attr('fillColor'),minValue:$.gchart._numeric(b.attr('minValue'),null),maxValue:$.gchart._numeric(b.attr('maxValue'),null),lineThickness:$.gchart._numeric(b.attr('lineThickness'),null),lineSegments:d})})}catch(e){}return(j?this.seriesForXYLines(h):h)},_numeric:function(a,b){a=parseFloat(a);return(isNaN(a)?b:a)},lineXYSeries:function(a){return this.seriesForXYLines(a)},seriesForXYLines:function(a){var b=[];for(var i=0;i<a.length;i++){var c=!$.isArray(a[i].data[0]);var d=(c?[null]:[]);var e=[];for(var j=0;j<a[i].data.length;j++){if(c){e.push(a[i].data[j])}else{d.push(a[i].data[j][0]);e.push(a[i].data[j][1])}}b.push($.gchart.series(a[i].label,d,a[i].color,a[i].fillColor,a[i].minValue,a[i].maxValue,a[i].lineThickness,a[i].lineSegments));b.push($.gchart.series(a[i].label,e,'',a[i].fillColor,a[i].minValue,a[i].maxValue,a[i].lineThickness,a[i].lineSegments))}return b},scatter:function(a,b,c,d){if(!$.isArray(b)){d=b;c=null;b=null}var e=[[],[],[]];for(var i=0;i<a.length;i++){e[0][i]=a[i][0];e[1][i]=a[i][1];e[2][i]=a[i][2]||100}d=d||{};if(b){d.extension={chdl:b.join('|')}}if(c){c=$.map(c,function(v,i){return $.gchart.color(v)});$.extend(d.extension,{chco:c.join('|')})}return $.extend({},d,{type:'scatter',series:[$.gchart.series(e[0]),$.gchart.series(e[1]),$.gchart.series(e[2])]})},venn:function(a,b,c,d,e,f,g,h){return $.extend({},h||{},{type:'venn',series:[$.gchart.series([a,b,c,d,e,f,g])]})},meter:function(a,b,c,d,e,f,g){if(typeof a!='string'&&!$.isArray(a)){g=f;f=e;e=d;d=c;c=b;b=a;a=''}if(typeof c!='number'){g=f;f=e;e=d;d=c;c=null}if(!$.isArray(d)){g=f;f=e;e=d;d=null}if(!$.isArray(e)){g=f;f=e;e=null}if(!$.isArray(f)){g=f;f=null}b=($.isArray(b)?b:[b]);var h=false;for(var i=0;i<b.length;i++){h=h||$.isArray(b[i])}var j=(h?[]:[$.gchart.series(b)]);if(h){for(var i=0;i<b.length;i++){j.push($.gchart.series($.isArray(b[i])?b[i]:[b[i]]))}}b=j;if(d){var k='';$.each(d,function(i,v){k+=','+$.gchart.color(v)});d=k.substr(1)}if(f){var l=['',''];$.each(f,function(i,v){v=($.isArray(v)?v:[v]);l[0]+='|'+$.gchart.color(v.slice(0,3).join(','));l[1]+='|'+(v[3]||15)});f=l[0].substr(1)+l[1]}var m=(e&&e.length?$.gchart.axis('y',e):null);return $.extend({},g||{},{type:'meter',maxValue:c||100,series:b,dataLabels:($.isArray(a)?a:[a||''])},(d?{extension:{chco:d}}:{}),(m?{axes:[m]}:{}),(f?{extension:{chls:f}}:{}))},map:function(a,b,c,d,e,f){if(typeof a=='object'){f=e;e=d;d=c;c=b;b=a;a='world'}if(typeof c=='object'){f=c;e=null;d=null;c=null}else if(typeof d=='object'&&!$.isArray(d)){f=d;e=null;d=null}else if(typeof e=='object'){f=e;e=null}var g=[];var h=[];var i=0;for(var j in b){g[i]=j;h[i]=b[j];i++}return $.extend({},f||{},{type:'map',mapArea:a,mapRegions:g,mapDefaultColor:c||$.gchart._defaults.mapDefaultColor,mapColors:($.isArray(d)?d:[d||$.gchart._defaults.mapColors[0],e||$.gchart._defaults.mapColors[1]]),series:[$.gchart.series('',h)]})},qrCode:function(a,b,c,d){var e={};if(typeof a=='object'){e=a}else{e={dataLabels:[a],encoding:b,qrECLevel:c,qrMargin:d}}e.type='qrCode';if(e.text){e.dataLabels=[e.text];e.text=null}return e},color:function(r,g,b,a){var c=function(a){if(typeof a=='number'&&(a<0||a>255)){throw'Value out of range (0-255) '+a;}};var d=function(a){return(a.length==1?'0':'')+a};if(typeof r=='string'){c(g);return(r.match(/^#([A-Fa-f0-9]{2}){3,4}$/)?r.substring(1):(H[r]||r)+(g?d(g.toString(16)):''))}c(r);c(g);c(b);c(a);return d(r.toString(16))+d(g.toString(16))+d(b.toString(16))+(a?d(a.toString(16)):'')},gradient:function(a,b,c){var d=[];if($.isArray(b)){var e=1/(b.length-1);for(var i=0;i<b.length;i++){d.push([b[i],Math.round(i*e*100)/100])}}else{d=[[b,0],[c,1]]}return{angle:a,colorPoints:d}},stripe:function(a,b){var c=[];var d=Math.round(100/b.length)/100;for(var i=0;i<b.length;i++){c.push([b[i],d])}return{angle:a,striped:true,colorPoints:c}},range:function(a,b,c,d){if(typeof a=='string'){d=c;c=b;b=a;a=false}return{vertical:a,color:b,start:c,end:d}},marker:function(a,b,c,d,e,f,g,h,i,j){if(typeof e=='boolean'){j=g;i=f;h=e;g=null;f=null;e=null}if($.isArray(e)){if(typeof e[0]=='string'){j=f;i=e}else{j=e;i=null}h=null;g=null;f=null;e=null}if(typeof f=='boolean'){j=h;i=g;h=f;g=null;f=null}if($.isArray(f)){if(typeof f[0]=='string'){j=g;i=f}else{j=f;i=null}h=null;g=null;f=null}if(typeof g=='boolean'){j=i;i=h;h=g;g=null}if($.isArray(g)){if(typeof g[0]=='string'){j=h;i=g}else{j=g;i=null}h=null;g=null}if($.isArray(h)){if(typeof h[0]=='string'){j=i;i=h}else{j=h;i=null}h=null}if($.isArray(i)&&typeof i[0]!='string'){j=i;i=null}return{shape:a,color:b,series:c,item:(d||d==0?d:-1),size:e||10,priority:(f!=null?f:0),text:g,positioned:h,placement:i,offsets:j}},icon:function(a,b,c,d,e,f,g){if($.isArray(c)){g=d;f=c;e=null;d=null;c=null}if($.isArray(e)){g=f;f=e;e=null}return{name:a,data:b,series:c||0,item:(d||d==0?d:'all'),zIndex:e,position:f,offsets:g}},numberFormat:function(a,b,c,d,e,f,g){var h=initNumberFormat(a,b,c,d,e,f,g);return h.prefix+'*'+h.type+h.precision+(h.zeroes?'z':'')+(h.separators?'s':'')+(h.showX?'x':'')+'*'+h.suffix},axis:function(a,b,c,d,e,f,g,h,i,j){return new GChartAxis(a,b,c,d,e,f,g,h,i,j)},findRegion:function(c,d){if(!d||!d.chartshape){return null}var e=function(a){var b=a.match(/([^\d]+)(\d+)(?:_(\d)+)?/);return{type:b[1],series:parseInt(b[2]),point:parseInt(b[3]||-1)}};var f=$(c.target).offset();var x=c.pageX-f.left;var y=c.pageY-f.top;for(var i=0;i<d.chartshape.length;i++){var g=d.chartshape[i];switch(g.type){case'RECT':if(g.coords[0]<=x&&x<=g.coords[2]&&g.coords[1]<=y&&y<=g.coords[3]){return e(g.name)}break;case'POLY':if($.gchart._insidePolygon(g.coords,x,y)){return e(g.name)}break}}return null},_insidePolygon:function(a,x,y){var b=0;var c=[a[0],a[1]];for(var i=2;i<=a.length;i+=2){var d=[a[i%a.length],a[i%a.length+1]];if(y>Math.min(c[1],d[1])&&y<=Math.max(c[1],d[1])){if(x<=Math.max(c[0],d[0])&&c[1]!=d[1]){var e=(y-c[1])*(d[0]-c[0])/(d[1]-c[1])+c[0];if(c[0]==d[0]||x<=e){b++}}}c=d}return(b%2!=0)},_attachGChart:function(a,b){a=$(a);if(a.is('.'+this.markerClassName)){return}a.addClass(this.markerClassName);b=b||{};var c=b.width||parseInt(a.css('width'),10);var d=b.height||parseInt(a.css('height'),10);var e=$.extend({},this._defaults,b,{width:c,height:d});$.data(a[0],G,e);this._updateChart(a[0],e)},_changeGChart:function(a,b,c){var d=b||{};if(typeof b=='string'){d={};d[b]=c}var e=$.data(a,G);extendRemove(e||{},d);$.data(a,G,e);this._updateChart(a,e)},_destroyGChart:function(a){a=$(a);if(!a.is('.'+this.markerClassName)){return}a.removeClass(this.markerClassName).empty();$.removeData(a[0],G)},_generateChart:function(d){var e=I[d.type]||'p3';var f=this['_'+d.encoding+'Encoding']||this['_textEncoding'];var g='';for(var i=0;i<d.dataLabels.length;i++){g+='|'+encodeURIComponent(d.dataLabels[i]||'')}g=(g.length==d.dataLabels.length?'':g);var h='';var j='';var k=false;var l='';for(var i=0;i<d.series.length;i++){h+='|'+encodeURIComponent(d.series[i].label||'');var m='';if(e!='lxy'||i%2==0){var n=',';$.each(($.isArray(d.series[i].color)?d.series[i].color:[d.series[i].color]),function(i,v){var a=$.gchart.color(v||'');if(a){k=true}m+=n+(a||'000000');n='|'})}j+=(k?m:'');if(e.substr(0,1)=='l'&&d.series[i].lineThickness&&$.isArray(d.series[i].lineSegments)){l+='|'+d.series[i].lineThickness+','+d.series[i].lineSegments.join(',')}}var o=function(a,b){return(b?a+b:'')};var p=function(){d.width=Math.max(10,Math.min(d.width,1000));d.height=Math.max(10,Math.min(d.height,1000));if(e!='t'&&d.width*d.height>300000){d.height=Math.floor(300000/d.width)}return(e!='t'?'&chs='+d.width+'x'+d.height:'&chs='+Math.min(440,d.width)+'x'+Math.min(220,d.height))};var q=function(){var a=d.margins;a=(a==null?null:(typeof a=='number'?[a,a,a,a]:(!$.isArray(a)?null:(a.length==4?a:(a.length==2?[a[0],a[0],a[1],a[1]]:null)))));return(!a?'':'&chma='+a.join(',')+(!d.legendSize||d.legendSize.length!=2?'':'|'+d.legendSize.join(',')))};var r=function(){return o('&choe=',d.encoding)+(d.qrECLevel||d.qrMargin?'&chld='+(d.qrECLevel?d.qrECLevel.charAt(0):'l')+(d.qrMargin!=null?'|'+d.qrMargin:''):'')+(g?'&chl='+g.substr(1):'')};var s=function(){var a='';for(var i=0;i<d.mapColors.length;i++){a+=','+$.gchart.color(d.mapColors[i])}return'&chtm='+(d.mapArea||'world')+'&chd='+f.apply($.gchart,[d])+(d.mapRegions&&d.mapRegions.length?'&chld='+d.mapRegions.join(''):'')+'&chco='+$.gchart.color(d.mapDefaultColor)+a};var t=function(){return(d.pieOrientation?'&chp='+(d.pieOrientation/180*Math.PI):'')+u()};var u=function(){return'&chd='+f.apply($.gchart,[d])+(g?'&chl='+g.substr(1):'')};var w=function(){return(e.substr(0,1)!='b'?'':(d.barWidth==null?'':'&chbh='+d.barWidth+(d.barSpacing==null?'':','+(d.barWidth==$.gchart.barWidthRelative?Math.min(Math.max(d.barSpacing,0.0),1.0):d.barSpacing)+(d.barGroupSpacing==null?'':','+(d.barWidth==$.gchart.barWidthRelative?Math.min(Math.max(d.barGroupSpacing,0.0),1.0):d.barGroupSpacing))))+(d.barZeroPoint==null?'':'&chp='+d.barZeroPoint))};var x=function(){return(e.charAt(0)=='l'&&l?'&chls='+l.substr(1):'')};var y=function(){return(j.length>d.series.length?'&chco='+j.substr(1):'')};var z=function(){return o('&chtt=',encodeURIComponent(d.title))+(d.titleColor||d.titleSize?'&chts='+($.gchart.color(d.titleColor)||'000000')+','+(d.titleSize||20):'')};var A=function(a,b){if(b==null){return''}if(typeof b=='string'){return a+',s,'+$.gchart.color(b)}var c=a+',l'+(b.striped?'s':'g')+','+(L[b.angle]!=null?L[b.angle]:b.angle);for(var i=0;i<b.colorPoints.length;i++){c+=','+$.gchart.color(b.colorPoints[i][0])+','+b.colorPoints[i][1]}return c};var B=function(){var a=(!d.opacity?null:'000000'+Math.floor(d.opacity/(d.opacity>1?100:1)*255).toString(16));if(a&&a.length<8){a='0'+a}var b=A('|a',a)+A('|bg',d.backgroundColor)+A('|c',d.chartColor);return(b?'&chf='+b.substr(1):'')};var C=function(){return(d.gridSize.length==0?'':'&chg='+d.gridSize[0]+','+d.gridSize[1]+(d.gridLine.length==0?'':','+d.gridLine[0]+','+d.gridLine[1]+(d.gridOffsets.length==0?'':','+d.gridOffsets[0]+','+d.gridOffsets[1])))};var D=function(){var a=(d.legendOrder&&d.legendOrder.match(/^\d+(,\d+)*$/)?d.legendOrder:O[d.legendOrder])||'';return(!d.legend||h.length<=d.series.length?'':'&chdl='+h.substr(1)+o('&chdlp=',d.legend.charAt(0)+(d.legend.indexOf('V')>-1?'v':'')+o('|',a)))};var E=function(){var a='';for(var b in d.extension){a+='&'+b+'='+d.extension[b]}return a};var F=d.format||'png';return'http://chart.apis.google.com/chart?'+(F!='png'?'chof='+F+'&':'')+'cht='+e+p()+q()+(e=='qr'?r():(e=='t'?s():(e.charAt(0)=='p'?t():u())))+w()+x()+y()+z()+this._addAxes(d)+B()+C()+this._addMarkers(d)+this._addIcons(d)+D()+E()},_addAxes:function(a){var b='';var c='';var d='';var e='';var f='';var g='';for(var i=0;i<a.axes.length;i++){var h=(typeof a.axes[i]=='string'?new GChartAxis(a.axes[i]):a.axes[i]);var k=h.axis().charAt(0);b+=','+(k=='b'?'x':(k=='l'?'y':k));if(h.labels()){var l='';for(var j=0;j<h.labels().length;j++){l+='|'+encodeURIComponent(h.labels()[j]||'')}c+=(l?'|'+i+':'+l:'')}if(h.positions()){var m='';for(var j=0;j<h.positions().length;j++){m+=','+h.positions()[j]}d+=(m?'|'+i+m:'')}if(h.range()){var n=h.range();e+='|'+i+','+n[0]+','+n[1]+(n[2]?','+n[2]:'')}if(h.style()||h.drawing()||h.ticks()||h.format()){var o=h.style()||{};var p=h.ticks()||{};f+='|'+i+(h.format()?'N'+this.numberFormat(h.format()):'')+','+$.gchart.color(o.color||'gray')+','+(o.size||10)+','+(M[o.alignment]||o.alignment||0)+(!h.drawing()&&!p.color?'':','+(N[h.drawing()]||h.drawing()||'lt')+(p.color?','+$.gchart.color(p.color):''))}if(h.ticks()&&h.ticks().length){g+='|'+i+','+h.ticks().length}}return(!b?'':'&chxt='+b.substr(1)+(!c?'':'&chxl='+c.substr(1))+(!d?'':'&chxp='+d.substr(1))+(!e?'':'&chxr='+e.substr(1))+(!f?'':'&chxs='+f.substr(1))+(!g?'':'&chxtc='+g.substr(1)))},_addMarkers:function(e){var f='';var g=function(a,b){if(a=='all'){return-1}if(typeof a=='string'){var c=/^every(\d+)(?:\[(\d+):(\d+)\])?$/.exec(a);if(c){var d=parseInt(c[1],10);return(c[2]&&c[3]?(b?Math.max(0.0,Math.min(1.0,c[2])):c[2])+':'+(b?Math.max(0.0,Math.min(1.0,c[3])):c[3])+':'+d:-d)}}if($.isArray(a)){a=$.map(a,function(v,i){return(b?Math.max(0.0,Math.min(1.0,v)):v)});return a.join(':')+(a.length<2?':':'')}return a};var h=function(a){return a.replace(/,/g,'\\,')};for(var i=0;i<e.markers.length;i++){var k=e.markers[i];var l=J[k.shape]||k.shape;var m='';if(k.placement){var n=$.makeArray(k.placement);for(var j=0;j<n.length;j++){m+=P[n[j]]||''}}f+='|'+(k.positioned?'@':'')+l+('AfNt'.indexOf(l)>-1?h(k.text||''):'')+','+$.gchart.color(k.color)+','+k.series+','+g(k.item,k.positioned)+','+k.size+','+(K[k.priority]!=null?K[k.priority]:k.priority)+(m||k.offsets?','+m+':'+(k.offsets&&k.offsets[0]?k.offsets[0]:'')+':'+(k.offsets&&k.offsets[1]?k.offsets[1]:''):'')}for(var i=0;i<e.ranges.length;i++){f+='|'+(e.ranges[i].vertical?'R':'r')+','+$.gchart.color(e.ranges[i].color)+',0,'+e.ranges[i].start+','+(e.ranges[i].end||e.ranges[i].start+0.005)}for(var i=0;i<e.series.length;i++){if(e.series[i].fillColor){var o=($.isArray(e.series[i].fillColor)?e.series[i].fillColor:[e.series[i].fillColor]);for(var j=0;j<o.length;j++){if(typeof o[j]=='string'){f+='|b,'+$.gchart.color(e.series[i].fillColor)+','+i+','+(i+1)+',0'}else{var p=($.isArray(o[j])?o[j]:[o[j].color,o[j].range]);f+='|B,'+$.gchart.color(p[0])+','+i+','+p[1]+',0'}}}}return(f?'&chm='+f.substr(1):'')},_addIcons:function(b){var c='';var d=function(a){if(a=='all'){return a}if(typeof a=='string'){if(/^every(\d+)$/.exec(a)){return a.replace(/every/,'every,')}}if($.isArray(a)){return'range,'+a.join(',')}return a};for(var i=0;i<b.icons.length;i++){var e=b.icons[i];c+='|y;s='+e.name+';d='+e.data+(e.position?'':';ds='+e.series+';dp='+d(e.item))+(e.zIndex?';py='+e.zIndex:'')+(e.position?';po='+e.position.join(','):'')+(e.offsets?';of='+e.offsets.join(','):'')}return(c?'&chem='+c.substr(1):'')},_updateChart:function(b,c){c._src=this._generateChart(c);if(c.usePost){var d='<form action="http://chart.apis.google.com/chart?'+Math.floor(Math.random()*1e8)+'" method="POST">';var e=/(\w+)=([^&]*)/g;var f=e.exec(c._src);while(f){d+='<input type="hidden" name="'+f[1]+'" value="'+($.inArray(f[1],['chdl','chl','chtt','chxl'])>-1?decodeURIComponent(f[2]):f[2])+'">';f=e.exec(c._src)}d+='</form>';b=$(b);b.empty();var g=$('<iframe></iframe>').appendTo(b).css({width:'100%',height:'100%'});var h=g.contents()[0];h.open();h.write(d);h.close();g.show().contents().find('form').submit()}else{var i=$(new Image());i.load(function(){$(b).find('img').remove().end().append(this);if(c.onLoad){if(c.provideJSON){$.getJSON(c._src+'&chof=json&callback=?',function(a){c.onLoad.apply(b,[$.gchart._normaliseRects(a)])})}else{c.onLoad.apply(b,[])}}});$(i).attr('src',c._src)}},_normaliseRects:function(a){if(a&&a.chartshape){for(var i=0;i<a.chartshape.length;i++){var b=a.chartshape[i];if(b.type=='RECT'){if(b.coords[0]>b.coords[2]){var c=b.coords[0];b.coords[0]=b.coords[2];b.coords[2]=c}if(b.coords[1]>b.coords[3]){var c=b.coords[1];b.coords[1]=b.coords[3];b.coords[3]=c}}}}return a},_textEncoding:function(a){var b=(a.minValue==$.gchart.calculate?this._calculateMinValue(a.series):a.minValue);var c=(a.maxValue==$.gchart.calculate?this._calculateMaxValue(a.series):a.maxValue);var d='';for(var i=0;i<a.series.length;i++){d+='|'+this._textEncode(a.series[i],b,c)}return't'+(a.visibleSeries||'')+':'+d.substr(1)},_textEncode:function(a,b,c){b=(a.minValue!=null?a.minValue:b);c=(a.maxValue!=null?a.maxValue:c);var d=100/(c-b);var e='';for(var i=0;i<a.data.length;i++){e+=','+(a.data[i]==null||isNaN(a.data[i])?'-1':Math.round(d*(a.data[i]-b)*100)/100)}return e.substr(1)},_scaledEncoding:function(a){var b=(a.minValue==$.gchart.calculate?this._calculateMinValue(a.series):a.minValue);var c=(a.maxValue==$.gchart.calculate?this._calculateMaxValue(a.series):a.maxValue);var d='';var e='';for(var i=0;i<a.series.length;i++){d+='|'+this._scaledEncode(a.series[i],b);e+=','+(a.series[i].minValue!=null?a.series[i].minValue:b)+','+(a.series[i].maxValue!=null?a.series[i].maxValue:c)}return't'+(a.visibleSeries||'')+':'+d.substr(1)+'&chds='+e.substr(1)},_scaledEncode:function(a,b){b=(a.minValue!=null?a.minValue:b);var c='';for(var i=0;i<a.data.length;i++){c+=','+(a.data[i]==null||isNaN(a.data[i])?(b-1):a.data[i])}return c.substr(1)},_simpleEncoding:function(a){var b=(a.minValue==$.gchart.calculate?this._calculateMinValue(a.series):a.minValue);var c=(a.maxValue==$.gchart.calculate?this._calculateMaxValue(a.series):a.maxValue);var d='';for(var i=0;i<a.series.length;i++){d+=','+this._simpleEncode(a.series[i],b,c)}return's'+(a.visibleSeries||'')+':'+d.substr(1)},_simpleEncode:function(a,b,c){b=(a.minValue!=null?a.minValue:b);c=(a.maxValue!=null?a.maxValue:c);var d=61/(c-b);var e='';for(var i=0;i<a.data.length;i++){e+=(a.data[i]==null||isNaN(a.data[i])?'_':Q.charAt(Math.round(d*(a.data[i]-b))))}return e},_extendedEncoding:function(a){var b=(a.minValue==$.gchart.calculate?this._calculateMinValue(a.series):a.minValue);var c=(a.maxValue==$.gchart.calculate?this._calculateMaxValue(a.series):a.maxValue);var d='';for(var i=0;i<a.series.length;i++){d+=','+this._extendedEncode(a.series[i],b,c)}return'e'+(a.visibleSeries||'')+':'+d.substr(1)},_extendedEncode:function(b,c,d){c=(b.minValue!=null?b.minValue:c);d=(b.maxValue!=null?b.maxValue:d);var e=4095/(d-c);var f=function(a){return R.charAt(a/64)+R.charAt(a%64)};var g='';for(var i=0;i<b.data.length;i++){g+=(b.data[i]==null||isNaN(b.data[i])?'__':f(Math.round(e*(b.data[i]-c))))}return g},_calculateMinValue:function(a){var b=99999999;for(var i=0;i<a.length;i++){var c=a[i].data;for(var j=0;j<c.length;j++){b=Math.min(b,(c[j]==null?99999999:c[j]))}}return b},_calculateMaxValue:function(a){var b=-99999999;for(var i=0;i<a.length;i++){var c=a[i].data;for(var j=0;j<c.length;j++){b=Math.max(b,(c[j]==null?-99999999:c[j]))}}return b}});function GChartAxis(a,b,c,d,e,f,g,h,i,j){if(typeof b=='number'){j=h;i=g;h=f;g=e;f=d;e=c;d=b;c=null;b=null}else if(!$.isArray(c)){j=i;i=h;h=g;g=f;f=e;e=d;d=c;c=null}if(typeof d=='string'){j=g;i=f;h=e;g=d;f=null;e=null;d=null}if(typeof f=='string'){j=i;i=h;h=g;g=f;f=null}if(typeof h=='number'){j=i;i=h;h=null}this._axis=a;this._labels=b;this._positions=c;this._range=(d!=null?[d,e,f]:null);this._color=g;this._alignment=h;this._size=i;this._drawing=null;this._tickColor=null;this._tickLength=null;this._format=j}$.extend(GChartAxis.prototype,{axis:function(a){if(arguments.length==0){return this._axis}this._axis=a;return this},labels:function(a){if(arguments.length==0){return this._labels}this._labels=a;return this},positions:function(a){if(arguments.length==0){return this._positions}this._positions=a;return this},range:function(a,b,c){if(arguments.length==0){return this._range}this._range=[a,b,c];return this},style:function(a,b,c){if(arguments.length==0){return(!this._color&&!this._alignment&&!this._size?null:{color:this._color,alignment:this._alignment,size:this._size})}this._color=a;this._alignment=b;this._size=c;return this},drawing:function(a){if(arguments.length==0){return this._drawing}this._drawing=a;return this},ticks:function(a,b){if(arguments.length==0){return(!this._tickColor&&!this._tickLength?null:{color:this._tickColor,length:this._tickLength})}this._tickColor=a;this._tickLength=b;return this},format:function(a,b,c,d,e,f,g){if(arguments.length==0){return this._format}this._format=initNumberFormat(a,b,c,d,e,f,g);return this}});function initNumberFormat(a,b,c,d,e,f,g){if(typeof a=='object'){return a}if(typeof b=='number'){g=e;f=d;e=c;d=b;c='';b=''}if(typeof b=='boolean'){g=d;f=c;e=b;d=0;c='';b=''}if(typeof c=='number'){g=f;f=e;e=d;d=c;c=''}if(typeof c=='boolean'){g=e;f=d;e=c;d=0;c=''}if(typeof d=='boolean'){g=f;f=e;e=d;d=0}return{type:a,prefix:b||'',suffix:c||'',precision:d||'',showX:e||false,zeroes:f||false,separators:g||false}}function extendRemove(a,b){$.extend(a,b);for(var c in b){if(b[c]==null){a[c]=null}}return a}$.fn.gchart=function(a){var b=Array.prototype.slice.call(arguments,1);if(a=='current'){return $.gchart['_'+a+'GChart'].apply($.gchart,[this[0]].concat(b))}return this.each(function(){if(typeof a=='string'){$.gchart['_'+a+'GChart'].apply($.gchart,[this].concat(b))}else{$.gchart._attachGChart(this,a)}})};$.gchart=new GChart()})(jQuery);